/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mods.waterstrainer.Config;
import mods.waterstrainer.WaterStrainer;
import mods.waterstrainer.block.BlockStrainerBase;
import mods.waterstrainer.util.LootTable;
import mods.waterstrainer.util.WaterStrainerUtils;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ItemStrainer
extends Item {
    private int curTooltipIndex = 0;
    private static Random rand = new Random();
    private long updateTime = System.currentTimeMillis();
    private List<String> tooltipData = new ArrayList<String>();
    public final EnumSubtype TYPE;
    public LootTable LOOT_TABLE;
    public final BlockStrainerBase.Model MODEL;

    public ItemStrainer(EnumSubtype strainerType) {
        super(new Item.Properties().func_200916_a(WaterStrainer.tabWaterStrainer).func_200918_c(100));
        this.setRegistryName(strainerType.regname);
        this.TYPE = strainerType;
        this.MODEL = strainerType.model;
        this.LOOT_TABLE = new LootTable();
    }

    public int getMaxDamage(ItemStack stack) {
        switch (this.TYPE) {
            case STRAINER_SURVIVALIST: {
                return Config.DURABILITY_STRAINER_SURVIVALIST;
            }
            case STRAINER_SURVIVALIST_SOLID: {
                return Config.DURABILITY_STRAINER_SURVIVALIST_SOLID;
            }
            case STRAINER_SURVIVALIST_REINFORCED: {
                return Config.DURABILITY_STRAINER_SURVIVALIST_REINFORCED;
            }
            case STRAINER_FISHERMAN: {
                return Config.DURABILITY_STRAINER_FISHERMAN;
            }
            case STRAINER_FISHERMAN_SOLID: {
                return Config.DURABILITY_STRAINER_FISHERMAN_SOLID;
            }
            case STRAINER_FISHERMAN_REINFORCED: {
                return Config.DURABILITY_STRAINER_FISHERMAN_REINFORCED;
            }
        }
        return 1;
    }

    public boolean func_77616_k(ItemStack strainer) {
        return this.TYPE.tier == StrainerTier.REINFORCED && Config.MISC_ENABLE_ENCHANTING;
    }

    public int func_77619_b() {
        return ArmorMaterial.IRON.func_200900_a();
    }

    public boolean isBookEnchantable(ItemStack strainer, ItemStack book) {
        if (!this.func_77616_k(strainer)) {
            return false;
        }
        for (Enchantment enchantment : EnchantmentHelper.func_82781_a((ItemStack)book).keySet()) {
            if (ItemStrainer.isValidEnchantment(enchantment)) continue;
            return false;
        }
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack strainer, Enchantment enchantment) {
        return ItemStrainer.isValidEnchantment(enchantment);
    }

    public static boolean isValidEnchantment(Enchantment enchantment) {
        return Config.MISC_ENABLE_ENCHANTING && (enchantment == Enchantments.field_185307_s || enchantment == Enchantments.field_185305_q || enchantment == Enchantments.field_185308_t || enchantment == Enchantments.field_151370_z);
    }

    public static int getEnchantmentLevel(ItemStack strainer, Enchantment enchantment) {
        if (Config.MISC_ENABLE_ENCHANTING) {
            return EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)strainer);
        }
        return 0;
    }

    public static boolean generateBonusItem(int level) {
        return level >= rand.nextInt(3) + 1;
    }

    public static boolean preventDamage(int level) {
        return level >= rand.nextInt(10) + 1;
    }

    public void func_77624_a(ItemStack stack, @Nullable World player, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        boolean shiftPressed = Screen.func_231173_s_();
        if (stack.func_77984_f()) {
            int uses = stack.func_77958_k() - stack.func_77952_i();
            String left = uses <= 1 ? "#GREEN#1 \u4f7f\u7528\u6b21\u6570" : String.format("#GREEN#%s \u4f7f\u7528\u6b21\u6570", uses);
            WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList(left));
        } else {
            WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList("#GREEN#\u4e0d\u4f1a\u635f\u574f"));
        }
        if (this.TYPE.tier == StrainerTier.SOLID) {
            if (Config.BONUS_SOLID_EFFICIENCY > 0) {
                WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList(String.format("#GREEN#+%s%% \u6548\u7387", Config.BONUS_SOLID_EFFICIENCY)));
            }
        } else if (this.TYPE.tier == StrainerTier.REINFORCED) {
            if (Config.BONUS_REINFORCED_EFFICIENCY > 0) {
                WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList(String.format("#GREEN#+%s%% \u6548\u7387", Config.BONUS_REINFORCED_EFFICIENCY)));
            }
            if (Config.MISC_ENABLE_ENCHANTING) {
                WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList("#GREEN#+\u53ef\u9644\u9b54"));
            }
        }
        if (shiftPressed || this.LOOT_TABLE.categories.size() == 0) {
            if (this.LOOT_TABLE.categories.size() > 0) {
                if (this.tooltipData.size() == 0) {
                    this.generateTooltip();
                }
                if (Math.abs(System.currentTimeMillis() - this.updateTime) > 1000L) {
                    this.updateTime = System.currentTimeMillis();
                    this.generateTooltip();
                }
                if (this.tooltipData.size() > 0) {
                    for (String t : this.tooltipData) {
                        WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList(t));
                    }
                }
            } else {
                WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList("#RED#\u8fd9\u4e2a\u6ee4\u7f51\u6ca1\u6709\u6709\u6548\u7684\u8f93\u51fa\u7269\u54c1\uff0c\u56e0\u6b64\u662f\u65e0\u7528\u7684.", "#RED#\u4f7f\u7528\u914d\u7f6e\u6587\u4ef6\u6dfb\u52a0\u6709\u6548\u7269\u54c1\u6216\u5b8c\u5168\u7981\u7528\u5b83.", "#RED#\u4f60\u4e5f\u53ef\u4ee5\u5220\u9664\u4f60\u7684loottable\u914d\u7f6e\u6765\u6062\u590d\u9ed8\u8ba4\u7684\u914d\u7f6e."));
            }
        } else {
            if (this.TYPE.category == StrainerCategory.FISHER) {
                WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList("\u6355\u83b7\u9c7c\u7c7b\u3001\u5783\u573e\u548c\u73cd\u5b9d.", "\u9700\u8981\u9c7c\u9975."));
            } else if (this.TYPE.category == StrainerCategory.SURVIVAL) {
                WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList("\u6536\u96c6\u4e00\u822c\u7269\u54c1."));
            }
            WaterStrainerUtils.generateTooltip(tooltip, Arrays.asList("\u9700\u8981\u4e00\u4e2a\u6ee4\u7f51\u57fa\u5ea7.", "\u6309 #GOLD#shift #GRAY#\u83b7\u53d6\u66f4\u591a\u4fe1\u606f."));
        }
    }

    private void generateTooltip() {
        this.tooltipData.clear();
        List<LootTable.Category> categories = this.LOOT_TABLE.categories;
        for (LootTable.Category cat : categories) {
            List<LootTable.Loot> lootlist = cat.items;
            int size = lootlist.size();
            if (size <= 0) continue;
            int index = this.curTooltipIndex % size;
            ItemStack lootstack = lootlist.get((int)index).stack;
            if (lootstack.func_190926_b()) continue;
            String descrString = String.format("%sx %s", lootstack.func_190916_E(), lootstack.func_200301_q().getString());
            float chance = Math.max(0.0f, 100.0f / ((float)this.LOOT_TABLE.lootTableMinIndex / (float)cat.rarity));
            descrString = String.format("%s (%.2f%%)", descrString, Float.valueOf(Math.max(0.0f, 100.0f / ((float)lootlist.get((int)(lootlist.size() - 1)).lootMaxIndex + 1.0f) * (float)lootlist.get((int)index).subRarity)));
            if (chance < 10.0f) {
                this.tooltipData.add(String.format("0%.2f%% - %s", Float.valueOf(chance), descrString));
                continue;
            }
            this.tooltipData.add(String.format("%.2f%% - %s", Float.valueOf(chance), descrString));
        }
        ++this.curTooltipIndex;
        if (this.curTooltipIndex >= 1000) {
            this.curTooltipIndex = 0;
        }
    }

    public int getEfficiencyBonus() {
        int efficiency = 0;
        if (this.TYPE.tier == StrainerTier.SOLID && Config.BONUS_SOLID_EFFICIENCY > 0) {
            efficiency += Config.BONUS_SOLID_EFFICIENCY;
        }
        if (this.TYPE.tier == StrainerTier.REINFORCED && Config.BONUS_REINFORCED_EFFICIENCY > 0) {
            efficiency += Config.BONUS_REINFORCED_EFFICIENCY;
        }
        return efficiency;
    }

    public static enum EnumSubtype {
        STRAINER_SURVIVALIST("strainer_survivalist", StrainerCategory.SURVIVAL, StrainerTier.NORMAL, BlockStrainerBase.Model.STRAINER_SURVIVALIST),
        STRAINER_SURVIVALIST_SOLID("strainer_survivalist_solid", StrainerCategory.SURVIVAL, StrainerTier.SOLID, BlockStrainerBase.Model.STRAINER_SURVIVALIST_SOLID),
        STRAINER_SURVIVALIST_REINFORCED("strainer_survivalist_reinforced", StrainerCategory.SURVIVAL, StrainerTier.REINFORCED, BlockStrainerBase.Model.STRAINER_SURVIVALIST_REINFORCED),
        STRAINER_FISHERMAN("strainer_fisherman", StrainerCategory.FISHER, StrainerTier.NORMAL, BlockStrainerBase.Model.STRAINER_FISHERMAN),
        STRAINER_FISHERMAN_SOLID("strainer_fisherman_solid", StrainerCategory.FISHER, StrainerTier.SOLID, BlockStrainerBase.Model.STRAINER_FISHERMAN_SOLID),
        STRAINER_FISHERMAN_REINFORCED("strainer_fisherman_reinforced", StrainerCategory.FISHER, StrainerTier.REINFORCED, BlockStrainerBase.Model.STRAINER_FISHERMAN_REINFORCED);

        public final BlockStrainerBase.Model model;
        public final StrainerCategory category;
        public final StrainerTier tier;
        public final String regname;

        private EnumSubtype(String name, StrainerCategory cat, StrainerTier tier, BlockStrainerBase.Model model) {
            this.regname = name;
            this.model = model;
            this.category = cat;
            this.tier = tier;
        }

        public static EnumSubtype getSubtype(ItemStack stack) {
            Item item = stack.func_77973_b();
            return item instanceof ItemStrainer ? ((ItemStrainer)item).TYPE : STRAINER_SURVIVALIST;
        }
    }

    public static enum StrainerTier {
        NORMAL,
        SOLID,
        REINFORCED;

    }

    public static enum StrainerCategory {
        SURVIVAL,
        FISHER;

    }
}

